<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('municipios', function (Blueprint $table) {
            $table->id();
            $table->string('nome',100); 
            $table->string('codigo')->nullable();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete(); // Responsável do município
            $table->foreignId('province_id')->constrained()->cascadeOnDelete(); // 
            $table->foreignId('entidade_id')->constrained()->cascadeOnDelete();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('municipios');
    }
};
